package demomodcode;


import slick.Texture;

import dangerzone.DamageTypes;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityExtendedRangeDamage;
import dangerzone.items.ItemSword;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.TextureMapper;
import dangerzone.rendering.WorldRenderer;

public class BigStick extends ItemSword {
	
	Texture texturebig = null;
	ModelBigStick ma = null;

	public BigStick(String n, String txt, int a, int b) {
		super(n, txt, a, b);
		burntime = 70;
		flipped = true;
	}
	

public void renderMeHeld(WorldRenderer wr, Entity e, InventoryContainer ic, boolean isdisplay){

		//texture is already auto-loaded for us
		if(texturebig == null){
			texturebig = TextureMapper.getTexture("demores/items/BigStickTexture.png");
		}
		DangerZone.wr.loadtexture(texturebig);
		if(ma == null){
			ma = new ModelBigStick();
		}
		
		
	    MatrixStack.sendCurrentStack();
	    MatrixStack.pushMatrix();
	    
	    if(isdisplay) {
	    	
	    	MatrixStack.translate(0.4f, -17.3f, -10.7f);
	    	MatrixStack.rotate(180f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
	    	MatrixStack.rotate(0.5f, 0.0f, 1.0f, 0.0f);
	    	MatrixStack.rotate(0.7f, 0.0f, 0.0f, 1.0f);

	    }else {
	    	

	    	/*							
			MatrixStack.translate((float)DangerZone.testx, (float)DangerZone.testy, (float)DangerZone.testz);
			MatrixStack.rotate(DangerZone.testp, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
			MatrixStack.rotate(DangerZone.testw+(bounce*4), 0.0f, 1.0f, 0.0f);
			MatrixStack.rotate(DangerZone.testr+(bounce*4), 0.0f, 0.0f, 1.0f);
	    	*/	
	    	
	    	MatrixStack.translate(2.9f+0.4f, -2.2f+-17.3f, 11.2f+-10.7f);
	    	MatrixStack.rotate(180f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
	    	MatrixStack.rotate(0.5f, 0.0f, 1.0f, 0.0f);
	    	MatrixStack.rotate(-19.6f+0.7f, 0.0f, 0.0f, 1.0f);
	    	

	    }
	    
	    
	    
	    MatrixStack.sendCurrentStack();
	    
		if(ma != null)ma.render();
		
		MatrixStack.popMatrix();
		
	}
	
	public boolean onLeftClick(Entity holder, Entity clickedon, InventoryContainer ic){
		if(holder == null)return false;
		if(!holder.world.isServer)return true;
		
		EntityExtendedRangeDamage e = (EntityExtendedRangeDamage)holder.world.createEntityByName("DangerZone:ExtendedRangeDamage", 
				holder.dimension, 
				holder.posx+(float)Math.sin(Math.toRadians(holder.rotation_yaw_head))*(holder.getWidth()+1)*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)),
				holder.posy+(holder.getHeight()*9/10) - (float)Math.sin(Math.toRadians(holder.rotation_pitch_head))*(holder.getWidth()+1),
				holder.posz+(float)Math.cos(Math.toRadians(holder.rotation_yaw_head))*(holder.getWidth()+1)*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)));
		if(e != null){
			e.init();
			e.setAttackDamage(attackstrength); //damage amount
			e.setDamageType(DamageTypes.SWORD); //damage type
			e.setExplosivePower(0); //explosive power
			e.setRange(8); //range
			e.thrower = holder;
			e.setDirectionAndVelocity(
					(float)Math.sin(Math.toRadians(holder.rotation_yaw_head))*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)), 
					-(float)Math.sin(Math.toRadians(holder.rotation_pitch_head)),
					(float)Math.cos(Math.toRadians(holder.rotation_yaw_head))*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)),
					25f, 0.01f);
			
			holder.world.spawnEntityInWorld(e);
		}
		
		return true; //continue with normal left click logic, else it is handled special here
	}
	
	

}
