/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class NVStreamConsumerEGLImage {
    public static final int EGL_STREAM_CONSUMER_IMAGE_NV = 13171;
    public static final int EGL_STREAM_IMAGE_ADD_NV = 13172;
    public static final int EGL_STREAM_IMAGE_REMOVE_NV = 13173;
    public static final int EGL_STREAM_IMAGE_AVAILABLE_NV = 13174;

    protected NVStreamConsumerEGLImage() {
        throw new UnsupportedOperationException();
    }

    public static int neglStreamImageConsumerConnectNV(long dpy, long stream, int num_modifiers, long modifiers, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglStreamImageConsumerConnectNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)stream);
        }
        return JNI.callPPPPI((long)dpy, (long)stream, (int)num_modifiers, (long)modifiers, (long)attrib_list, (long)__functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglStreamImageConsumerConnectNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLuint64KHR *") LongBuffer modifiers, @Nullable @NativeType(value="EGLAttrib *") PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((PointerBuffer)attrib_list, (long)12344L);
        }
        return NVStreamConsumerEGLImage.neglStreamImageConsumerConnectNV(dpy, stream, modifiers.remaining(), MemoryUtil.memAddress((LongBuffer)modifiers), MemoryUtil.memAddressSafe((Pointer)attrib_list)) != 0;
    }

    public static int neglQueryStreamConsumerEventNV(long dpy, long stream, long timeout, long event, long aux) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamConsumerEventNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)stream);
        }
        return JNI.callPPJPPI((long)dpy, (long)stream, (long)timeout, (long)event, (long)aux, (long)__functionAddress);
    }

    @NativeType(value="EGLint")
    public static int eglQueryStreamConsumerEventNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLTime") long timeout, @NativeType(value="EGLenum *") IntBuffer event, @NativeType(value="EGLAttrib *") PointerBuffer aux) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)event, (int)1);
            Checks.check((CustomBuffer)aux, (int)1);
        }
        return NVStreamConsumerEGLImage.neglQueryStreamConsumerEventNV(dpy, stream, timeout, MemoryUtil.memAddress((IntBuffer)event), MemoryUtil.memAddress((CustomBuffer)aux));
    }

    public static int neglStreamAcquireImageNV(long dpy, long stream, long pImage, long sync) {
        long __functionAddress = EGL.getCapabilities().eglStreamAcquireImageNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)stream);
            Checks.check((long)sync);
        }
        return JNI.callPPPPI((long)dpy, (long)stream, (long)pImage, (long)sync, (long)__functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglStreamAcquireImageNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLImage *") PointerBuffer pImage, @NativeType(value="EGLSync") long sync) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pImage, (int)1);
        }
        return NVStreamConsumerEGLImage.neglStreamAcquireImageNV(dpy, stream, MemoryUtil.memAddress((CustomBuffer)pImage), sync) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglStreamReleaseImageNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLImage") long image, @NativeType(value="EGLSync") long sync) {
        long __functionAddress = EGL.getCapabilities().eglStreamReleaseImageNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)stream);
            Checks.check((long)image);
            Checks.check((long)sync);
        }
        return JNI.callPPPPI((long)dpy, (long)stream, (long)image, (long)sync, (long)__functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglStreamImageConsumerConnectNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLuint64KHR *") long[] modifiers, @Nullable @NativeType(value="EGLAttrib *") PointerBuffer attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglStreamImageConsumerConnectNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)stream);
            Checks.checkNTSafe((PointerBuffer)attrib_list, (long)12344L);
        }
        return JNI.callPPPPI((long)dpy, (long)stream, (int)modifiers.length, (long[])modifiers, (long)MemoryUtil.memAddressSafe((Pointer)attrib_list), (long)__functionAddress) != 0;
    }

    @NativeType(value="EGLint")
    public static int eglQueryStreamConsumerEventNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLTime") long timeout, @NativeType(value="EGLenum *") int[] event, @NativeType(value="EGLAttrib *") PointerBuffer aux) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamConsumerEventNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)stream);
            Checks.check((int[])event, (int)1);
            Checks.check((CustomBuffer)aux, (int)1);
        }
        return JNI.callPPJPPI((long)dpy, (long)stream, (long)timeout, (int[])event, (long)MemoryUtil.memAddress((CustomBuffer)aux), (long)__functionAddress);
    }
}

