/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.ovr.OVRVector2i;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrRecti")
public class OVRRecti
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POS;
    public static final int SIZE;

    public OVRRecti(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRRecti.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrVector2i")
    public OVRVector2i Pos() {
        return OVRRecti.nPos(this.address());
    }

    @NativeType(value="ovrSizei")
    public OVRSizei Size() {
        return OVRRecti.nSize(this.address());
    }

    public OVRRecti Pos(@NativeType(value="ovrVector2i") OVRVector2i value) {
        OVRRecti.nPos(this.address(), value);
        return this;
    }

    public OVRRecti Pos(Consumer<OVRVector2i> consumer) {
        consumer.accept(this.Pos());
        return this;
    }

    public OVRRecti Size(@NativeType(value="ovrSizei") OVRSizei value) {
        OVRRecti.nSize(this.address(), value);
        return this;
    }

    public OVRRecti Size(Consumer<OVRSizei> consumer) {
        consumer.accept(this.Size());
        return this;
    }

    public OVRRecti set(OVRVector2i Pos, OVRSizei Size) {
        this.Pos(Pos);
        this.Size(Size);
        return this;
    }

    public OVRRecti set(OVRRecti src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRRecti malloc() {
        return (OVRRecti)OVRRecti.wrap(OVRRecti.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRRecti calloc() {
        return (OVRRecti)OVRRecti.wrap(OVRRecti.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRRecti create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRRecti)OVRRecti.wrap(OVRRecti.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRRecti create(long address) {
        return (OVRRecti)OVRRecti.wrap(OVRRecti.class, (long)address);
    }

    @Nullable
    public static OVRRecti createSafe(long address) {
        return address == 0L ? null : (OVRRecti)OVRRecti.wrap(OVRRecti.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRRecti.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRRecti.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRRecti.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRRecti.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRRecti.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRRecti.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRRecti.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static OVRRecti mallocStack() {
        return OVRRecti.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRRecti callocStack() {
        return OVRRecti.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRRecti mallocStack(MemoryStack stack) {
        return OVRRecti.malloc(stack);
    }

    @Deprecated
    public static OVRRecti callocStack(MemoryStack stack) {
        return OVRRecti.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRRecti.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRRecti.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRRecti.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRRecti.calloc(capacity, stack);
    }

    public static OVRRecti malloc(MemoryStack stack) {
        return (OVRRecti)OVRRecti.wrap(OVRRecti.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRRecti calloc(MemoryStack stack) {
        return (OVRRecti)OVRRecti.wrap(OVRRecti.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRRecti.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRRecti.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static OVRVector2i nPos(long struct) {
        return OVRVector2i.create(struct + (long)POS);
    }

    public static OVRSizei nSize(long struct) {
        return OVRSizei.create(struct + (long)SIZE);
    }

    public static void nPos(long struct, OVRVector2i value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POS), (long)OVRVector2i.SIZEOF);
    }

    public static void nSize(long struct, OVRSizei value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SIZE), (long)OVRSizei.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRRecti.__struct((Struct.Member[])new Struct.Member[]{OVRRecti.__member((int)OVRVector2i.SIZEOF, (int)OVRVector2i.ALIGNOF), OVRRecti.__member((int)OVRSizei.SIZEOF, (int)OVRSizei.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POS = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRRecti, Buffer>
    implements NativeResource {
        private static final OVRRecti ELEMENT_FACTORY = OVRRecti.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRRecti getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrVector2i")
        public OVRVector2i Pos() {
            return OVRRecti.nPos(this.address());
        }

        @NativeType(value="ovrSizei")
        public OVRSizei Size() {
            return OVRRecti.nSize(this.address());
        }

        public Buffer Pos(@NativeType(value="ovrVector2i") OVRVector2i value) {
            OVRRecti.nPos(this.address(), value);
            return this;
        }

        public Buffer Pos(Consumer<OVRVector2i> consumer) {
            consumer.accept(this.Pos());
            return this;
        }

        public Buffer Size(@NativeType(value="ovrSizei") OVRSizei value) {
            OVRRecti.nSize(this.address(), value);
            return this;
        }

        public Buffer Size(Consumer<OVRSizei> consumer) {
            consumer.accept(this.Size());
            return this;
        }
    }
}

