/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRQuatf;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerCube")
public class OVRLayerCube
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int ORIENTATION;
    public static final int CUBEMAPTEXTURE;

    public OVRLayerCube(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRLayerCube.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerCube.nHeader(this.address());
    }

    @NativeType(value="ovrQuatf")
    public OVRQuatf Orientation() {
        return OVRLayerCube.nOrientation(this.address());
    }

    @NativeType(value="ovrTextureSwapChain")
    public long CubeMapTexture() {
        return OVRLayerCube.nCubeMapTexture(this.address());
    }

    public OVRLayerCube Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerCube.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerCube Header(Consumer<OVRLayerHeader> consumer) {
        consumer.accept(this.Header());
        return this;
    }

    public OVRLayerCube Orientation(@NativeType(value="ovrQuatf") OVRQuatf value) {
        OVRLayerCube.nOrientation(this.address(), value);
        return this;
    }

    public OVRLayerCube Orientation(Consumer<OVRQuatf> consumer) {
        consumer.accept(this.Orientation());
        return this;
    }

    public OVRLayerCube CubeMapTexture(@NativeType(value="ovrTextureSwapChain") long value) {
        OVRLayerCube.nCubeMapTexture(this.address(), value);
        return this;
    }

    public OVRLayerCube set(OVRLayerHeader Header, OVRQuatf Orientation, long CubeMapTexture) {
        this.Header(Header);
        this.Orientation(Orientation);
        this.CubeMapTexture(CubeMapTexture);
        return this;
    }

    public OVRLayerCube set(OVRLayerCube src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRLayerCube malloc() {
        return (OVRLayerCube)OVRLayerCube.wrap(OVRLayerCube.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRLayerCube calloc() {
        return (OVRLayerCube)OVRLayerCube.wrap(OVRLayerCube.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRLayerCube create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRLayerCube)OVRLayerCube.wrap(OVRLayerCube.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRLayerCube create(long address) {
        return (OVRLayerCube)OVRLayerCube.wrap(OVRLayerCube.class, (long)address);
    }

    @Nullable
    public static OVRLayerCube createSafe(long address) {
        return address == 0L ? null : (OVRLayerCube)OVRLayerCube.wrap(OVRLayerCube.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRLayerCube.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRLayerCube.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRLayerCube.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRLayerCube.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRLayerCube.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRLayerCube.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRLayerCube.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static OVRLayerCube mallocStack() {
        return OVRLayerCube.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerCube callocStack() {
        return OVRLayerCube.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerCube mallocStack(MemoryStack stack) {
        return OVRLayerCube.malloc(stack);
    }

    @Deprecated
    public static OVRLayerCube callocStack(MemoryStack stack) {
        return OVRLayerCube.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRLayerCube.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRLayerCube.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerCube.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerCube.calloc(capacity, stack);
    }

    public static OVRLayerCube malloc(MemoryStack stack) {
        return (OVRLayerCube)OVRLayerCube.wrap(OVRLayerCube.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRLayerCube calloc(MemoryStack stack) {
        return (OVRLayerCube)OVRLayerCube.wrap(OVRLayerCube.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRLayerCube.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRLayerCube.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static OVRQuatf nOrientation(long struct) {
        return OVRQuatf.create(struct + (long)ORIENTATION);
    }

    public static long nCubeMapTexture(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CUBEMAPTEXTURE));
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HEADER), (long)OVRLayerHeader.SIZEOF);
    }

    public static void nOrientation(long struct, OVRQuatf value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ORIENTATION), (long)OVRQuatf.SIZEOF);
    }

    public static void nCubeMapTexture(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CUBEMAPTEXTURE), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CUBEMAPTEXTURE)));
    }

    static {
        Struct.Layout layout = OVRLayerCube.__struct((Struct.Member[])new Struct.Member[]{OVRLayerCube.__member((int)OVRLayerHeader.SIZEOF, (int)OVRLayerHeader.ALIGNOF, (boolean)true), OVRLayerCube.__member((int)OVRQuatf.SIZEOF, (int)OVRQuatf.ALIGNOF), OVRLayerCube.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        ORIENTATION = layout.offsetof(1);
        CUBEMAPTEXTURE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerCube, Buffer>
    implements NativeResource {
        private static final OVRLayerCube ELEMENT_FACTORY = OVRLayerCube.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRLayerCube getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerCube.nHeader(this.address());
        }

        @NativeType(value="ovrQuatf")
        public OVRQuatf Orientation() {
            return OVRLayerCube.nOrientation(this.address());
        }

        @NativeType(value="ovrTextureSwapChain")
        public long CubeMapTexture() {
            return OVRLayerCube.nCubeMapTexture(this.address());
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerCube.nHeader(this.address(), value);
            return this;
        }

        public Buffer Header(Consumer<OVRLayerHeader> consumer) {
            consumer.accept(this.Header());
            return this;
        }

        public Buffer Orientation(@NativeType(value="ovrQuatf") OVRQuatf value) {
            OVRLayerCube.nOrientation(this.address(), value);
            return this;
        }

        public Buffer Orientation(Consumer<OVRQuatf> consumer) {
            consumer.accept(this.Orientation());
            return this;
        }

        public Buffer CubeMapTexture(@NativeType(value="ovrTextureSwapChain") long value) {
            OVRLayerCube.nCubeMapTexture(this.address(), value);
            return this;
        }
    }
}

